/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1997 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUNotifyUtils.cpp
//
//
//	Description:
//		This library contains the source and
//		routines to simplify the use of suites and also some
//		helpful common plug-in functions. 
//
//	Use:
//		PIUNotifyUtils is intended to group common functions
//		into higher-level macros and routines to simplify
//		plug-in programming.
//
//	Version history:
//		Version 1.0.0	12/14/1997	Created for Photoshop 5.0
//			Written by Andrew Coven.
//
//-------------------------------------------------------------------------------

#include "PIUNotifyUtils.h"

#ifdef __PIMac__

PIUNotifyUtils_t::PIUNotifyUtils_t()
	{
	// Intentionally left blank.
	}

PIUNotifyUtils_t::
	PIUNotifyUtils_t
	(
	const PIUNotifyUtils_t & source
	)
	{
	#pragma unused (source)
	// Intentionally left blank.
	}

PIUNotifyUtils_t & PIUNotifyUtils_t::operator=
	(
	const PIUNotifyUtils_t & source
	)
	{
	#pragma unused (source)
	return *this;
	}

QDGlobals* PIUNotifyUtils_t::GetQDGlobals (void)
{
	
	return (QDGlobals *) ((* (char **) SetCurrentA5 ()) -
						 (sizeof (QDGlobals) - sizeof (GrafPtr)));
	
}

void PIUNotifyUtils_t::SetArrowCursor (void)
{
	
	QDGlobals *qd = GetQDGlobals();
	
	SetCursor (&(qd->arrow));
	
}

#endif // __PIMac__
